using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for PatientInfoToolbar.
	/// </summary>
	public class PatientInfoToolbar : GUI.controls.BaseControl
	{
		#region Variables

		/// <summary>
		/// One entry to show
		/// </summary>
		private bool _singleRowDisplay = true;

		/// <summary>
		/// Local Patient object
		/// </summary>
		private BOL.Patient _patient;

		private BOL.BloodAvailability _bloodAvailability;

		private System.Guid _parentFormInstanceGuid = System.Guid.Empty;
		
		#endregion



		#region Controls

		private System.Windows.Forms.Button btnCurrentMeds;
		private System.Windows.Forms.Button btnBloodAvailability;
		private System.Windows.Forms.Button btnSpecialInstructions;
		private System.Windows.Forms.ToolTip ttToolTip;
		private System.Windows.Forms.Button btnRecentOrders;
		private System.Windows.Forms.Button btnTransfusionReactionHistory;
		private System.Windows.Forms.Button btnRecentTransfusionsIssues;
		private System.Windows.Forms.HelpProvider hlpHelpChm;
		private System.ComponentModel.IContainer components;

		#endregion

		#region Constructors/Destructors

		/// <summary>
		/// PatientInfoToolbar
		/// </summary>
		public PatientInfoToolbar()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
			//
			#if !DESIGN
					this.hlpHelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			#else 
				#if !DESIGN
					this.hlpHelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
				#endif
			#endif
			
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(PatientInfoToolbar));
			this.btnCurrentMeds = new System.Windows.Forms.Button();
			this.btnBloodAvailability = new System.Windows.Forms.Button();
			this.btnSpecialInstructions = new System.Windows.Forms.Button();
			this.btnTransfusionReactionHistory = new System.Windows.Forms.Button();
			this.btnRecentTransfusionsIssues = new System.Windows.Forms.Button();
			this.btnRecentOrders = new System.Windows.Forms.Button();
			this.ttToolTip = new System.Windows.Forms.ToolTip(this.components);
			this.hlpHelpChm = new System.Windows.Forms.HelpProvider();
			this.SuspendLayout();
			// 
			// btnCurrentMeds
			// 
			this.btnCurrentMeds.AccessibleDescription = "Patient Medication Profile";
			this.btnCurrentMeds.AccessibleName = "Patient Medication Profile";
			this.btnCurrentMeds.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCurrentMeds.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.hlpHelpChm.SetHelpKeyword(this.btnCurrentMeds, "");
			this.btnCurrentMeds.Image = ((System.Drawing.Image)(resources.GetObject("btnCurrentMeds.Image")));
			this.btnCurrentMeds.Location = new System.Drawing.Point(78, 0);
			this.btnCurrentMeds.Name = "btnCurrentMeds";
			this.hlpHelpChm.SetShowHelp(this.btnCurrentMeds, false);
			this.btnCurrentMeds.Size = new System.Drawing.Size(24, 20);
			this.btnCurrentMeds.TabIndex = 3;
			this.ttToolTip.SetToolTip(this.btnCurrentMeds, "Display Medication Profile.");
			this.btnCurrentMeds.Click += new System.EventHandler(this.btnCurrentMeds_Click);
			// 
			// btnBloodAvailability
			// 
			this.btnBloodAvailability.AccessibleDescription = "Blood Availability";
			this.btnBloodAvailability.AccessibleName = "Blood Availability";
			this.btnBloodAvailability.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.hlpHelpChm.SetHelpKeyword(this.btnBloodAvailability, "");
			this.btnBloodAvailability.Image = ((System.Drawing.Image)(resources.GetObject("btnBloodAvailability.Image")));
			this.btnBloodAvailability.Location = new System.Drawing.Point(26, 0);
			this.btnBloodAvailability.Name = "btnBloodAvailability";
			this.hlpHelpChm.SetShowHelp(this.btnBloodAvailability, false);
			this.btnBloodAvailability.Size = new System.Drawing.Size(24, 20);
			this.btnBloodAvailability.TabIndex = 1;
			this.ttToolTip.SetToolTip(this.btnBloodAvailability, "Display Patient Blood Availability.");
			this.btnBloodAvailability.Click += new System.EventHandler(this.btnBloodAvailability_Click);
			// 
			// btnSpecialInstructions
			// 
			this.btnSpecialInstructions.AccessibleDescription = "Special Instructions";
			this.btnSpecialInstructions.AccessibleName = "Special Instructions";
			this.btnSpecialInstructions.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.hlpHelpChm.SetHelpKeyword(this.btnSpecialInstructions, "");
			this.btnSpecialInstructions.Image = ((System.Drawing.Image)(resources.GetObject("btnSpecialInstructions.Image")));
			this.btnSpecialInstructions.Location = new System.Drawing.Point(0, 0);
			this.btnSpecialInstructions.Name = "btnSpecialInstructions";
			this.hlpHelpChm.SetShowHelp(this.btnSpecialInstructions, false);
			this.btnSpecialInstructions.Size = new System.Drawing.Size(24, 20);
			this.btnSpecialInstructions.TabIndex = 0;
			this.ttToolTip.SetToolTip(this.btnSpecialInstructions, "Display Special Instructions and Transfusion Requirements.");
			this.btnSpecialInstructions.Click += new System.EventHandler(this.btnSpecialInstructions_Click);
			// 
			// btnTransfusionReactionHistory
			// 
			this.btnTransfusionReactionHistory.AccessibleDescription = "Transfusion Reaction History";
			this.btnTransfusionReactionHistory.AccessibleName = "Transfusion Reaction History";
			this.btnTransfusionReactionHistory.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnTransfusionReactionHistory.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.hlpHelpChm.SetHelpKeyword(this.btnTransfusionReactionHistory, "");
			this.btnTransfusionReactionHistory.Image = ((System.Drawing.Image)(resources.GetObject("btnTransfusionReactionHistory.Image")));
			this.btnTransfusionReactionHistory.Location = new System.Drawing.Point(130, 0);
			this.btnTransfusionReactionHistory.Name = "btnTransfusionReactionHistory";
			this.hlpHelpChm.SetShowHelp(this.btnTransfusionReactionHistory, false);
			this.btnTransfusionReactionHistory.Size = new System.Drawing.Size(24, 20);
			this.btnTransfusionReactionHistory.TabIndex = 5;
			this.ttToolTip.SetToolTip(this.btnTransfusionReactionHistory, "Display Transfusion Reaction History.");
			this.btnTransfusionReactionHistory.Click += new System.EventHandler(this.btnTransfusionReactionHistory_Click);
			// 
			// btnRecentTransfusionsIssues
			// 
			this.btnRecentTransfusionsIssues.AccessibleDescription = "Recent Transfusions and Issued Units";
			this.btnRecentTransfusionsIssues.AccessibleName = "Recent Transfusions and Issued Units";
			this.btnRecentTransfusionsIssues.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnRecentTransfusionsIssues.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.hlpHelpChm.SetHelpKeyword(this.btnRecentTransfusionsIssues, "");
			this.btnRecentTransfusionsIssues.Image = ((System.Drawing.Image)(resources.GetObject("btnRecentTransfusionsIssues.Image")));
			this.btnRecentTransfusionsIssues.Location = new System.Drawing.Point(104, 0);
			this.btnRecentTransfusionsIssues.Name = "btnRecentTransfusionsIssues";
			this.hlpHelpChm.SetShowHelp(this.btnRecentTransfusionsIssues, false);
			this.btnRecentTransfusionsIssues.Size = new System.Drawing.Size(24, 20);
			this.btnRecentTransfusionsIssues.TabIndex = 4;
			this.ttToolTip.SetToolTip(this.btnRecentTransfusionsIssues, "Display Recent Transfusion/Issue History.");
			this.btnRecentTransfusionsIssues.Click += new System.EventHandler(this.btnRecentTransfusionsIssues_Click);
			// 
			// btnRecentOrders
			// 
			this.btnRecentOrders.AccessibleDescription = "Recent Orders";
			this.btnRecentOrders.AccessibleName = "Recent Orders";
			this.btnRecentOrders.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.hlpHelpChm.SetHelpKeyword(this.btnRecentOrders, "");
			this.btnRecentOrders.Image = ((System.Drawing.Image)(resources.GetObject("btnRecentOrders.Image")));
			this.btnRecentOrders.Location = new System.Drawing.Point(52, 0);
			this.btnRecentOrders.Name = "btnRecentOrders";
			this.hlpHelpChm.SetShowHelp(this.btnRecentOrders, false);
			this.btnRecentOrders.Size = new System.Drawing.Size(24, 20);
			this.btnRecentOrders.TabIndex = 2;
			this.ttToolTip.SetToolTip(this.btnRecentOrders, "Display recent orders.");
			this.btnRecentOrders.Click += new System.EventHandler(this.btnRecentOrders_Click);
			// 
			// ttToolTip
			// 
			this.ttToolTip.ShowAlways = true;
			// 
			// PatientInfoToolbar
			// 
			this.Controls.Add(this.btnCurrentMeds);
			this.Controls.Add(this.btnBloodAvailability);
			this.Controls.Add(this.btnSpecialInstructions);
			this.Controls.Add(this.btnTransfusionReactionHistory);
			this.Controls.Add(this.btnRecentTransfusionsIssues);
			this.Controls.Add(this.btnRecentOrders);
			this.hlpHelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.Name = "PatientInfoToolbar";
			this.hlpHelpChm.SetShowHelp(this, true);
			this.Size = new System.Drawing.Size(154, 20);
			this.ResumeLayout(false);

		}
		#endregion


		#region Control Events

		/// <summary>
		/// Bubbles up the user activity to the container form
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void BubbleUserActivity(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
		}

		/// <summary>
		/// Calls the event when special instructions and patient transfusion requirements button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSpecialInstructions_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (this._patient != null)
			{
				DlgDisplayTransReqsAndSpecIns dlg = new DlgDisplayTransReqsAndSpecIns(this._patient);

				dlg.RefreshParentLockTimeEvent += new EventHandler(this.BubbleUserActivity);

                if (dlg.DialogResult != DialogResult.Abort)
                {
                    VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                    dlg.ShowDialogFromLockedParent(parentForm, false);
                }
                else
                    dlg.Dispose();
			}
		}

		/// <summary>
		/// Calls the event when blood availability button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnBloodAvailability_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (this._patient != null)
			{
				DlgReportBloodAvailability dlg = new DlgReportBloodAvailability(_bloodAvailability);
                dlg.RefreshParentLockTimeEvent += new EventHandler(this.BubbleUserActivity);
                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                dlg.ShowDialogFromLockedParent(parentForm, false);
			}
		}

		/// <summary>
		/// Calls the event when patient VBECS data button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnRecentOrders_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (this._patient == null)
				return;

			DlgRecentOrders dlg = new DlgRecentOrders(this._patient);
            dlg.RefreshParentLockTimeEvent += new EventHandler(this.BubbleUserActivity);
            VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
            dlg.ShowDialogFromLockedParent(parentForm, false);
		}

		/// <summary>
		/// Calls the event when patient current medications button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCurrentMeds_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if( this._patient == null )
				return;

			FrmMedProfile dlg = new FrmMedProfile( this._patient );
            dlg.RefreshParentLockTimeEvent += new EventHandler(this.BubbleUserActivity);
            VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
            dlg.ShowDialogFromLockedParent(parentForm, false);
		}

		/// <summary>
		/// Calls the event when patient transfusion history button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnRecentTransfusionsIssues_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (this._patient == null)
				return;
			
			DlgRecentTransfusionsIssues dlg = new DlgRecentTransfusionsIssues(this._patient);
            dlg.RefreshParentLockTimeEvent += new EventHandler(this.BubbleUserActivity);
            VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
            dlg.ShowDialogFromLockedParent(parentForm, false);
		}

		/// <summary>
		/// Calls the event when patient clinical data button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnTransfusionReactionHistory_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (this._patient == null)
				return;
			
			DlgTransfusionReactionHistory dlg = new DlgTransfusionReactionHistory(this._patient);
            dlg.RefreshParentLockTimeEvent += new EventHandler(this.BubbleUserActivity);
            VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
            dlg.ShowDialogFromLockedParent(parentForm, false);
		}


		#endregion

		#region Properties

		/// <summary>
		/// The Guid of the container holing the toolbar (where any locks may have been created)
		/// Need this for child-form closing
		/// </summary>
		public System.Guid ParentFormInstanceGuid
		{
			get
			{
				return this._parentFormInstanceGuid;
			}
			set
			{
				this._parentFormInstanceGuid = value;
			}
		}

		/// <summary>
		/// Display tool bar as single or double row
		/// </summary>
		[
		Category("Appearance"),
		Description("Display tool bar as single or double row"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool SingleRowDisplay
		{
			get
			{
				return this._singleRowDisplay;
			}
			set
			{
				this._singleRowDisplay = value;
				//
				if (this._singleRowDisplay)
				{
					this.Size = new Size(154,20);
				}
				else
				{
					this.Size = new Size(76,42);
				}
			}
		}

		/// <summary>
		/// Indicates whether the SI (and) TR button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the SI & TR button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledSIAndTRButton
		{
			get
			{
				return this.btnSpecialInstructions.Enabled;
			}
			set
			{
				// only beep one time!
				if (value && !this.btnSpecialInstructions.Enabled ) Common.Utility.MessageBeep();
				this.btnSpecialInstructions.Enabled = value;
			}
		}

		/// <summary>
		/// Indicates whether the blood availability button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the blood availability button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledBloodAvailButton
		{
			get
			{
				return this.btnBloodAvailability.Enabled;
			}
			set
			{
				this.btnBloodAvailability.Enabled = value;
			}
		}

		/// <summary>
		/// Indicates whether the Recent Orders button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Recent Orders button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledRecentOrdersButton
		{
			get
			{
				return this.btnRecentOrders.Enabled;
			}
			set
			{
				this.btnRecentOrders.Enabled = value;
			}
		}

		/// <summary>
		/// Indicates whether the Medication Profile button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Medication Profile button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledMedicationButton
		{
			get
			{
				return this.btnCurrentMeds.Enabled;
			}
			set
			{
				this.btnCurrentMeds.Enabled = value;
			}
		}

		/// <summary>
		/// Indicates whether the Recent Transfusios/Issued Units button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Recent Transfusios/Issued Units button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledRecentTransfusionsIssuesButton
		{
			get
			{
				return this.btnRecentTransfusionsIssues.Enabled;
			}
			set
			{
				this.btnRecentTransfusionsIssues.Enabled = value;
			}
		}

		/// <summary>
		/// Indicates whether the Transfusion Reaction History button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Transfusion Reaction History button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledTransfusionReactionHistoryButton
		{
			get
			{
				return this.btnTransfusionReactionHistory.Enabled;
			}
			set
			{
				this.btnTransfusionReactionHistory.Enabled = value;
			}
		}


		/// <summary>
		/// Current working Patient object
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return this._patient;
			}
			set
			{
				// reset button
				this.EnabledSIAndTRButton = false;

				this._patient = value;
				//
				if (this._patient != null)
				{
					//Medication button is always enabled
					this.btnCurrentMeds.Enabled = true;
					//
					// BR_16.01 - Enable only when there are Special Instructions or Transfusion Requirements to display
					this.EnabledSIAndTRButton = ( BOL.PatientSpecialInstruction.DoActiveSpecialInstructionsExistForPatient(this._patient.PatientGuid) || 
						BOL.PatientTransfusionRequirement.DoTransfusionRequirementsExistForPatient(this._patient.PatientGuid) );
					//
					//Adding the patient filter to UC_49 report
					this._bloodAvailability = new BOL.BloodAvailability();
					this._bloodAvailability.IsIndividualPatientReport = true;
					this._bloodAvailability.IsMultiDivisional = false;
					this._bloodAvailability.PatientGuid = this._patient.PatientGuid;
					//Find the number of blood units for selected patient. Enable only if entries found
					int count=_bloodAvailability.GetBloodAvailabilityCount();
					this.btnBloodAvailability.Enabled = (count>0);
					//
					//Find the number of patient transfusion reactions. Enable only if entries found
					int transfusionReactions = BOL.PatientTransfusionReaction.GetTransfusionReactionsForPatientCount(this._patient.PatientGuid);
					this.btnTransfusionReactionHistory.Enabled = (transfusionReactions>0);
					//
					//Find the number of recent transfusions/issues. Enable only if entries found
					int issueTransfusions = BOL.PatientTransfusion.GetRecentlyIssuedAndTransfusedUnitsForPatientCount(this._patient.PatientGuid);
					this.btnRecentTransfusionsIssues.Enabled = (issueTransfusions>0);
					//
					//Find the number of recent test orders. Enable only if entries found
					int recentTestOrders = BOL.OrderedTest.GetRecentTestOrdersCount(this._patient.PatientGuid);
					if (recentTestOrders>0)
					{
						this.btnRecentOrders.Enabled = true;
					}
					else
					{
						//No need to check component orders if we've already found test orders.
						int recentComponentOrders = BOL.OrderedComponent.GetRecentComponentOrdersCount(this._patient.PatientGuid);
						if (recentComponentOrders>0)
						{
							this.btnRecentOrders.Enabled = true;
						}
						else
						{
							this.btnRecentOrders.Enabled = false;
						}
					}
				}
				else
				{
					this.EnableAllButtons(false);
				}
			}
		}


		#endregion

		#region Methods

		/// <summary>
		/// EnableAllButtons
		/// </summary>
		/// <param name="enable"></param>
		public void EnableAllButtons(bool enable)
		{
			this.btnBloodAvailability.Enabled = enable;
			this.btnRecentOrders.Enabled = enable;
			this.btnCurrentMeds.Enabled = enable;
			this.btnTransfusionReactionHistory.Enabled = enable;
			this.btnSpecialInstructions.Enabled = enable;
			this.btnRecentTransfusionsIssues.Enabled = enable;
		}

		#endregion

	}
}
